module Redwood

## a fully-functional text field supporting completions, expansions,
## history--everything!
## 
## writing this fucking sucked. if you thought ncurses was some 1970s
## before-people-knew-how-to-program bullshit, wait till you see
## ncurses forms.
##
## completion comments: completion is done emacs-style, and mostly
## depends on outside support, as we merely signal the existence of a
## new set of completions to show (#new_completions?)  or that the
## current list of completions should be rolled if they're too large
## to fill the screen (#roll_completions?).
##
## in sup, completion support is implemented through BufferManager#ask
## and CompletionMode.
class TextField
  def initialize window, y, x, width
    @w, @x, @y = window, x, y
    @width = width
    @i = nil
    @history = []

    @completion_block = nil
    reset_completion_state
  end

  bool_reader :new_completions, :roll_completions
  attr_reader :completions

  def value; @value || get_cursed_value end

  def activate question, default=nil, &block
    @question = question
    @completion_block = block
    @field = Ncurses::Form.new_field 1, @width - question.length,
                                     @y, @x + question.length, 0, 0
    @form = Ncurses::Form.new_form [@field]
    @value = default
    Ncurses::Form.post_form @form
    set_cursed_value default if default
  end

  def position_cursor
    @w.attrset Colormap.color_for(:none)
    @w.mvaddstr @y, 0, @question
    Ncurses.curs_set 1
    Ncurses::Form.form_driver @form, Ncurses::Form::REQ_END_FIELD
    Ncurses::Form.form_driver @form, Ncurses::Form::REQ_NEXT_CHAR if @value && @value =~ / $/ # fucking RETARDED!!!!
  end

  def deactivate
    reset_completion_state
    @form.unpost_form
    @form.free_form
    @field.free_field
    @field = nil
    Ncurses.curs_set 0
  end

  def handle_input c
    ## short-circuit exit paths
    case c
    when Ncurses::KEY_ENTER # submit!
      @value = get_cursed_value
      @history.push @value
      return false
    when Ncurses::KEY_CANCEL # cancel
      @value = nil
      return false
    when Ncurses::KEY_TAB # completion
      return true unless @completion_block
      if @completions.empty?
        v = get_cursed_value
        c = @completion_block.call v
        if c.size > 0
          @value = c.map { |full, short| full }.shared_prefix(true)
          set_cursed_value @value
          position_cursor
        end
        if c.size > 1
          @completions = c
          @new_completions = true
          @roll_completions = false
        end
      else
        @new_completions = false
        @roll_completions = true
      end
      return true
    end

    reset_completion_state
    @value = nil

    d =
      case c
      when Ncurses::KEY_LEFT
        Ncurses::Form::REQ_PREV_CHAR
      when Ncurses::KEY_RIGHT
        Ncurses::Form::REQ_NEXT_CHAR
      when Ncurses::KEY_BACKSPACE
        Ncurses::Form::REQ_DEL_PREV
      when 1 #ctrl-a
        Ncurses::Form::REQ_BEG_FIELD
      when 5 #ctrl-e
        Ncurses::Form::REQ_END_FIELD
      when 11 # ctrl-k
        Ncurses::Form::REQ_CLR_EOF
      when Ncurses::KEY_UP
        @i ||= @history.size
        @history[@i] = get_cursed_value
        @i = (@i - 1) % @history.size
        @value = @history[@i]
        set_cursed_value @value
      when Ncurses::KEY_DOWN
        @i ||= @history.size
        @history[@i] = get_cursed_value
        @i = (@i + 1) % @history.size
        @value = @history[@i]
        set_cursed_value @value
      else
        c
      end

    Ncurses::Form.form_driver @form, d
    true
  end

private

  def reset_completion_state
    @completions = []
    @new_completions = @roll_completions = @clear_completions = false
  end

  ## ncurses inanity wrapper
  ##
  ## DO NOT READ THIS CODE. YOU WILL GO MAD.
  def get_cursed_value
    return nil unless @field

    x = Ncurses.curx
    Ncurses::Form.form_driver @form, Ncurses::Form::REQ_VALIDATION
    v = @field.field_buffer(0).gsub(/^\s+|\s+$/, "")

    ## cursor <= end of text
    if x - @question.length - v.length <= 0
      v
    else # trailing spaces
      v + (" " * (x - @question.length - v.length))
    end
  end

  def set_cursed_value v
    @field.set_field_buffer 0, v
  end
end
end
